[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Expert)"
set var=CONF_DESCRIPTION value="tr(3,Routed PPPoA Packet Service configuration with backup.)"
set var=CONF_SERVICE value="tr(4,Routed PPPoA - Backup)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value="8.35"
set var=BAK_ip value=""
set var=BAK_dns value=""

[ wizard.ini ]
' ATM=PVC Settings
'----------------------------
def var=ATM type=grp desc="tr(5,Specify the details of the Routed PPPoA Packet Service. All information should be provided by your ISP.)" alias="tr(6,Routed PPPoA Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" req=yes desc="tr(7,Choose a VPI/VCI from the list)" default=8.35
' PPP=Settings
'-------------
def var=PPP type=grp desc="tr(8,Specify the details of the Routed PPP Account. All information should be provided by your ISP.)" alias="tr(9,PPP Account Settings)"
def var=PPP_user type=string grp=PPP alias="tr(10,User Name)" req=yes desc="tr(11,Enter your Internet connection user name.)"
def var=%PPP_pwd type=passw grp=PPP alias="tr(12,Password)" req=yes desc="tr(13,Enter your Internet connection password.)" max=32
' Backup=Settings
'----------------
def var=BAK type=grp desc="tr(14,Specify the IP details of the backup connection.)" alias="tr(15,Backup Connection Settings)"
def var=BAK_ip type=ipaddr grp=BAK alias="tr(16,Backup Router)" req=yes desc="tr(17,Enter the IP address of the backup router.)"
def var=BAK_dns type=ipaddr grp=BAK alias="tr(18,DNS Server)" req=yes desc="tr(19,Enter the IP address of the DNS server.)"
'ST Security
'-----------
def var=ST type=grp desc="tr(20,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(21,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(22,User Name)" desc="tr(23,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(24,Password)" desc="tr(25,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(26,Confirm Password)" desc="tr(27,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=PVC_1 addr=$ATM_addr type=any
add name=USB addr=usb.0.35 type=any logging=off

[ bridge.ini ]
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
config autodhcp=on scantime=10 state=enabled trace=off
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=10.0.0.1 poolend=10.0.0.254 netmask=255.255.255.0 gateway=10.0.0.138 leasetime=7200

[ ethoa.ini ]

[ ipoa.ini ]

[ pppoa.ini ]
ifadd intf=PPPoA_1
rtadd intf=PPPoA_1 dst=0.0.0.0/0 src=0.0.0.0/0
ifconfig intf=PPPoA_1 dest=PVC_1 user=$PPP_user password=$%PPP_pwd accomp=on addrtrans=pat restart=on
ifattach intf=PPPoA_1

[ pppoe.ini ]

[ pppoerelay.ini ]

[ cip.ini ]

[ ip.ini ]
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0
rtadd dst=$BAK_dns dstmsk=255.255.255.255 intf=PPPoA_1
rtadd dst=0.0.0.0/0 gateway=$BAK_ip metric=10

[ dnsd.ini ]
domain domain=lan
add hostname=SpeedTouch
fwdadd dns=$BAK_dns src=0.0.0.0/0 direct=no
fwdadd dns=$BAK_ip src=0.0.0.0/0 direct=no
start
troff

[ dhcr.ini ]
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138

[ autopvc.ini ]
config mode=passive type=bridge

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ upnp.ini ]
config defcservice=PPPoA_1

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Expert"
t r="3, Configuratie met routed-PPPoA Packet-service en reserveverbinding."
t r="4, Routed PPPoA - reserveverbinding"
t r="5, Geef de details van de routed-PPPoA Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Routed-PPPoA Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Geef de details van de routed-PPP-account op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="9, Instellingen van PPP-account"
t r="10, Gebruikersnaam"
t r="11, Geef de gebruikersnaam voor uw Internet-verbinding in."
t r="12, Wachtwoord"
t r="13, Geef het wachtwoord voor uw Internet-verbinding in."
t r="14, Geef de IP-gegevens van de reserveverbinding op."
t r="15, Instellingen van reserveverbinding"
t r="16, Reserverouter"
t r="17, Geef het IP-adres van de reserverouter in."
t r="18, DNS-server"
t r="19, Geef het IP-adres van de DNS-server in."
t r="20, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="21, SpeedTouch-beveiliging"
t r="22, Gebruikersnaam"
t r="23, Geef uw gebruikersnaam in."
t r="24, Wachtwoord"
t r="25, Geef uw wachtwoord in."
t r="26, Wachtwoord bevestigen"
t r="27, Geef uw wachtwoord nogmaals in."
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Expert"
t r="3, Configuration du service de transmission par paquets PPPoA rout avec connexion de secours."
t r="4, PPPoA rout et connexion de secours"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets PPPoA rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets PPPoA rout"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Spcifiez les dtails relatifs au compte de la connexion PPP route. Toutes ces informations doivent tre fournies par votre FAI."
t r="9, Paramtres du compte PPP"
t r="10, Nom d'utilisateur"
t r="11, Entrez le nom d'utilisateur employ pour votre connexion  Internet."
t r="12, Mot de passe"
t r="13, Entrez le mot de passe employ pour votre connexion  Internet."
t r="14, Spcifiez les informations IP de la connexion de secours."
t r="15, Paramtres de la connexion de secours"
t r="16, Routeur de secours"
t r="17, Entrez l'adresse IP du routeur de secours."
t r="18, Serveur DNS"
t r="19, Entrez l'adresse IP du serveur DNS."
t r="20, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="21, Scurit SpeedTouch"
t r="22, Nom d'utilisateur"
t r="23, Entrez un nom d'utilisateur."
t r="24, Mot de passe"
t r="25, Entrez votre mot de passe."
t r="26, Confirmer le mot de passe"
t r="27, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Expert"
t r="3, Konfiguration des Routed PPPoA-Paketdienstes mit Backup."
t r="4, Routed PPPoA - Backup"
t r="5, Geben Sie die Einzelheiten zum Routed PPPoA-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Routed PPPoA-Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Geben Sie die Einzelheiten zum Routed PPP-Konto an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="9, Einstellungen fr das PPP-Konto"
t r="10, Benutzername"
t r="11, Geben Sie den Benutzernamen fr die Internetverbindung ein."
t r="12, Kennwort"
t r="13, Geben Sie das Kennwort fr die Internetverbindung ein."
t r="14, Geben Sie die IP-Informationen fr die Backupverbindung an."
t r="15, Einstellungen fr die Backupverbindung"
t r="16, Backuprouter"
t r="17, Geben Sie die IP-Adresse des Backuprouters ein."
t r="18, DNS-Server"
t r="19, Geben Sie die IP-Adresse des DNS-Servers ein."
t r="20, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="21, SpeedTouch Sicherheit"
t r="22, Benutzername"
t r="23, Geben Sie den Benutzernamen ein."
t r="24, Kennwort"
t r="25, Geben Sie das Kennwort ein."
t r="26, Kennwort besttigen"
t r="27, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Esperta"
t r="3, Configurazione per la trasmissione di pacchetti in modalit routed PPPoA con backup."
t r="4, Routed PPPoA - Backup"
t r="5, Specificare i dettagli per la trasmissione di pacchetti in modalit routed PPPoA. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Trasmissione di pacchetti in modalit routed PPPoA"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Specificare i dettagli dell'account routed PPP. Tutte le informazioni devono essere fornite dall'ISP."
t r="9, Impostazioni account PPP"
t r="10, Nome utente"
t r="11, Immettere il nome utente di connessione a Internet."
t r="12, Password"
t r="13, Immettere la password di connessione a Internet."
t r="14, Specificare i dettagli IP della connessione di backup."
t r="15, Impostazioni connessione di backup"
t r="16, Router di backup"
t r="17, Immettere l'indirizzo IP del router di backup."
t r="18, Server DNS"
t r="19, Immettere l'indirizzo IP del server DNS."
t r="20, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="21, Sicurezza SpeedTouch"
t r="22, Nome utente"
t r="23, Immettere il nome utente."
t r="24, Password"
t r="25, Immettere la password."
t r="26, Conferma password"
t r="27, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Avanado"
t r="3, Configurao do Servio de Pacote do PPPoA Roteado com backup."
t r="4, PPPoA roteado - Backup"
t r="5, Especifique os detalhes do Routed PPPoA Packet Service. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote do PPPoA Roteado"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Especifique os detalhes da Conta do PPP Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="9, Configuraes da Conta do PPP"
t r="10, Nome do usurio"
t r="11, Digite seu nome do usurio de conexo com a Internet."
t r="12, Senha"
t r="13, Digite sua senha de conexo com a Internet."
t r="14, Especifique os detalhes IP da conexo de backup."
t r="15, Configuraes da conexo de backup"
t r="16, Roteador de backup"
t r="17, Insira o endereo IP do roteador de backup."
t r="18, Servidor DNS"
t r="19, Insira o endereo IP do servidor DNS."
t r="20, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="21, Segurana do SpeedTouch"
t r="22, Nome do usurio"
t r="23, Digite o nome do usurio."
t r="24, Senha"
t r="25, Digite sua senha."
t r="26, Confirme a senha"
t r="27, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Experto"
t r="3, Configuracin de servicios de paquetes PPPoA enrutados con copia de seguridad."
t r="4, PPPoA enrutados; copia de seguridad"
t r="5, Indique los detalles del servicio de paquetes PPPoA enrutados. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicio de paquetes PPPoA enrutados"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Indique los detalles de la cuenta PPP enrutada. Toda la informacin debe proporcionarla el ISP."
t r="9, Configuracin de cuentas PPP"
t r="10, Nombre de usuario"
t r="11, Escriba el nombre de usuario de conexin a Internet."
t r="12, Contrasea"
t r="13, Escriba la contrasea de conexin a Internet."
t r="14, Indique los detalles de IP de la conexin de copia de seguridad."
t r="15, Configuracin de la conexin de copia de seguridad"
t r="16, Enrutador de copia de seguridad"
t r="17, Escriba la direccin IP del enrutador de copia de seguridad."
t r="18, Servidor DNS"
t r="19, Escriba la direccin IP del servidor DNS."
t r="20, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="21, Seguridad de SpeedTouch"
t r="22, Nombre de usuario"
t r="23, Escriba el nombre de usuario."
t r="24, Contrasea"
t r="25, Escriba la contrasea."
t r="26, Confirme la contrasea"
t r="27, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Expert"
t r="3, Konfiguration fr Routed PPPoA Packet Service med backup."
t r="4, Routed PPPoA - Backup"
t r="5, Ange information om Routed PPPoA Packet Service. Din ISP ska kunna ge all information."
t r="6, Routed PPPoA Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Ange information om kontot fr Routed PPP. Din ISP ska kunna ge all information."
t r="9, Kontoinstllningar fr PPP"
t r="10, Anvndarnamn"
t r="11, Ange anvndarnamn fr din Internet-anslutning."
t r="12, Lsenord"
t r="13, Ange lsenord fr din Internet-anslutning."
t r="14, Ange IP-information fr backup-anslutningen."
t r="15, Instllningar fr backup-anslutningen"
t r="16, Backup-router"
t r="17, Ange IP-adress fr backup-routern."
t r="18, DNS-server"
t r="19, Ange IP-adress fr DNS-servern."
t r="20, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="21, SpeedTouch-skerhet"
t r="22, Anvndarnamn"
t r="23, Ange anvndarnamn."
t r="24, Lsenord"
t r="25, Ange lsenord."
t r="26, Bekrfta lsenord"
t r="27, Ange ditt lsenord igen"

[ endofarch ]
